<?php
/**
 * ----------------------------------------------------
 * Process Inventory Koperasi
 * ----------------------------------------------------
 */

require_once '../config/config.php';
require_once '../config/database.php';
require_once '../config/auth.php';

$aksi = $_POST['aksi'] ?? null;

if (!$aksi) {
    die('Aksi tidak valid');
}

/* ===============================
   BARANG MASUK
================================ */
if ($aksi === 'masuk') {

    $tanggal    = $_POST['tanggal'];
    $barang_id  = $_POST['barang_id'];
    $jumlah     = $_POST['jumlah'];
    $harga      = $_POST['harga'];
    $keterangan = $_POST['keterangan'];

    if ($jumlah <= 0 || $harga < 0) {
        die('Data tidak valid');
    }

    $total = $jumlah * $harga;

    // Insert inventory masuk
    $stmt = $db->prepare("
        INSERT INTO inventory_masuk 
        (tanggal, barang_id, jumlah, harga, keterangan)
        VALUES (?, ?, ?, ?, ?)
    ");
    $stmt->execute([$tanggal, $barang_id, $jumlah, $harga, $keterangan]);

    // Update stok
    $db->prepare("
        UPDATE barang SET stok = stok + ?
        WHERE id = ?
    ")->execute([$jumlah, $barang_id]);

    // Kas keluar
    $db->prepare("
        INSERT INTO kas (tanggal, masuk, keluar, keterangan)
        VALUES (?, 0, ?, ?)
    ")->execute([$tanggal, $total, 'Pembelian barang']);

    header('Location: ../modules/inventory/stok.php');
    exit;
}

/* ===============================
   BARANG KELUAR
================================ */
if ($aksi === 'keluar') {

    $tanggal    = $_POST['tanggal'];
    $barang_id  = $_POST['barang_id'];
    $jumlah     = $_POST['jumlah'];
    $harga      = $_POST['harga'];
    $keterangan = $_POST['keterangan'];

    if ($jumlah <= 0 || $harga < 0) {
        die('Data tidak valid');
    }

    // Ambil stok
    $stmt = $db->prepare("SELECT stok FROM barang WHERE id = ?");
    $stmt->execute([$barang_id]);
    $barang = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$barang || $barang['stok'] < $jumlah) {
        die('Stok tidak mencukupi');
    }

    $total = $jumlah * $harga;

    // Insert inventory keluar
    $stmt = $db->prepare("
        INSERT INTO inventory_keluar
        (tanggal, barang_id, jumlah, harga, keterangan)
        VALUES (?, ?, ?, ?, ?)
    ");
    $stmt->execute([$tanggal, $barang_id, $jumlah, $harga, $keterangan]);

    // Update stok
    $db->prepare("
        UPDATE barang SET stok = stok - ?
        WHERE id = ?
    ")->execute([$jumlah, $barang_id]);

    // Kas masuk
    $db->prepare("
        INSERT INTO kas (tanggal, masuk, keluar, keterangan)
        VALUES (?, ?, 0, ?)
    ")->execute([$tanggal, $total, 'Penjualan barang']);

    header('Location: ../modules/inventory/stok.php');
    exit;
}

die('Aksi tidak dikenali');
